/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.platform.Services;
import com.hrznstudio.emojiful.util.EmojiUtil;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_377;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_384;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class EmojiFontRenderer
extends class_327 {
    public static final class_1160 SHADOW_OFFSET = new class_1160(0.0f, 0.0f, 0.03f);
    public static LoadingCache<String, Pair<String, HashMap<Integer, Emoji>>> RECENT_STRINGS = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Pair<String, HashMap<Integer, Emoji>>>(){

        public Pair<String, HashMap<Integer, Emoji>> load(String key) throws Exception {
            return EmojiFontRenderer.getEmojiFormattedString(key);
        }
    });
    private static final String MY_NAME = "DevNotWorkingRn";
    private class_1058 sprite;

    public EmojiFontRenderer(class_327 fontRenderer) {
        super(fontRenderer.field_1997, fontRenderer.field_39925);
    }

    public static Pair<String, HashMap<Integer, Emoji>> getEmojiFormattedString(String text) {
        LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap<Integer, Emoji>();
        if (Services.CONFIG.renderEmoji() && !StringUtil.isNullOrEmpty((String)text)) {
            String unformattedText = class_124.method_539((String)text);
            if (StringUtil.isNullOrEmpty((String)unformattedText)) {
                return Pair.of((Object)text, emojis);
            }
            for (Emoji emoji : Constants.EMOJI_LIST) {
                Pattern pattern = emoji.getRegex();
                Matcher matcher = pattern.matcher(unformattedText);
                while (matcher.find()) {
                    if (matcher.group().isEmpty()) continue;
                    String emojiText = matcher.group();
                    int index = text.indexOf(emojiText);
                    emojis.put(index, emoji);
                    LinkedHashMap<Integer, Emoji> clean = new LinkedHashMap<Integer, Emoji>();
                    for (Integer integer : new ArrayList(((HashMap)emojis).keySet())) {
                        if (integer <= index) continue;
                        Emoji e = (Emoji)((HashMap)emojis).get(integer);
                        emojis.remove(integer);
                        clean.put(integer - emojiText.length() + 1, e);
                    }
                    emojis.putAll(clean);
                    unformattedText = unformattedText.replaceFirst(Pattern.quote(emojiText), "\u2603");
                    text = text.replaceFirst("(?i)" + Pattern.quote(emojiText), "\u2603");
                }
            }
        }
        return Pair.of((Object)text, emojis);
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public int method_1727(String text) {
        if (text != null) {
            try {
                text = (String)((Pair)RECENT_STRINGS.get((Object)text.replaceAll(MY_NAME, "DevNotWorkingRn :blobcatbolb: "))).getKey();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.method_1727(text);
    }

    public int method_27525(class_5348 textProperties) {
        return this.method_1727(textProperties.getString());
    }

    public int method_30880(class_5481 processor) {
        StringBuilder builder = new StringBuilder();
        processor.accept((p_accept_1_, p_accept_2_, ch) -> {
            builder.append((char)ch);
            return true;
        });
        return this.method_1727(builder.toString());
    }

    public int method_27521(String p_228079_1_, float p_228079_2_, float p_228079_3_, int p_228079_4_, boolean p_228079_5_, class_1159 p_228079_6_, class_4597 p_228079_7_, boolean p_228079_8_, int p_228079_9_, int p_228079_10_) {
        return super.method_27521(p_228079_1_, p_228079_2_, p_228079_3_, p_228079_4_, p_228079_5_, p_228079_6_, p_228079_7_, p_228079_8_, p_228079_9_, p_228079_10_);
    }

    public float method_1724(String text, float x, float y, int color, boolean isShadow, class_1159 matrix, class_4597 buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        if (text.isEmpty()) {
            return 0.0f;
        }
        HashMap emojis = new LinkedHashMap<Integer, Emoji>();
        try {
            Pair cache = (Pair)RECENT_STRINGS.get((Object)text.replaceAll(MY_NAME, "DevNotWorkingRn :blobcatbolb: "));
            text = (String)cache.getLeft();
            emojis = (HashMap)cache.getRight();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        EmojiCharacterRenderer fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, isShadow, matrix, isTransparent, packedLight);
        class_5223.method_27479((String)text, (class_2583)class_2583.field_24360, (class_5224)fontrenderer$characterrenderer);
        return fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
    }

    public int method_22942(class_5481 reorderingProcessor, float x, float y, int color, boolean isShadow, class_1159 matrix, class_4597 buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        if (reorderingProcessor != null) {
            String text;
            StringBuilder builder = new StringBuilder();
            if (reorderingProcessor != null) {
                reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                    builder.append((char)ch);
                    return true;
                });
            }
            if ((text = builder.toString().replaceAll(MY_NAME, "DevNotWorkingRn :blobcatbolb:")).length() > 0) {
                EmojiCharacterRenderer fontrenderer$characterrenderer;
                color = (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
                LinkedHashMap<Integer, Emoji> emojis = new LinkedHashMap();
                try {
                    Pair cache = (Pair)RECENT_STRINGS.get((Object)text);
                    text = (String)cache.getLeft();
                    emojis = (HashMap)cache.getRight();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                ArrayList processors = new ArrayList();
                LinkedHashMap finalEmojis = emojis;
                AtomicInteger cleanPos = new AtomicInteger();
                AtomicBoolean ignore = new AtomicBoolean(false);
                reorderingProcessor.accept((pos, style, ch) -> {
                    if (!ignore.get()) {
                        if (finalEmojis.get(cleanPos.get()) == null) {
                            processors.add(new CharacterProcessor(cleanPos.getAndIncrement(), style, ch));
                        } else {
                            processors.add(new CharacterProcessor(cleanPos.get(), style, 32));
                            ignore.set(true);
                            return true;
                        }
                    }
                    if (ignore.get() && ch == 58) {
                        ignore.set(false);
                        cleanPos.getAndIncrement();
                    }
                    return true;
                });
                StringBuilder builder2 = new StringBuilder();
                class_5481.method_30755(processors).accept((p_accept_1_, p_accept_2_, ch) -> {
                    builder2.append((char)ch);
                    return true;
                });
                class_1159 matrix4f = matrix.method_22673();
                if (isShadow) {
                    fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, true, matrix, isTransparent, packedLight);
                    class_5481.method_30755(processors).accept((class_5224)fontrenderer$characterrenderer);
                    fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
                    matrix4f.method_22671(SHADOW_OFFSET);
                }
                fontrenderer$characterrenderer = new EmojiCharacterRenderer(emojis, buffer, x, y, color, false, matrix4f, isTransparent, packedLight);
                class_5481.method_30755(processors).accept((class_5224)fontrenderer$characterrenderer);
                return (int)fontrenderer$characterrenderer.finish(colorBackgroundIn, x);
            }
        }
        return super.method_22942(reorderingProcessor, x, y, color, isShadow, matrix, buffer, isTransparent, colorBackgroundIn, packedLight);
    }

    class EmojiCharacterRenderer
    implements class_5224 {
        final class_4597 buffer;
        private final boolean dropShadow;
        private final float dimFactor;
        private final float r;
        private final float g;
        private final float b;
        private final float a;
        private final class_1159 matrix;
        private final boolean seeThrough;
        private final int packedLight;
        private float x;
        private final float y;
        private final HashMap<Integer, Emoji> emojis;
        @Nullable
        private List<class_382.class_328> effects;

        public EmojiCharacterRenderer(HashMap<Integer, Emoji> emojis, class_4597 p_i232250_2_, float p_i232250_3_, float p_i232250_4_, int p_i232250_5_, boolean p_i232250_6_, class_1159 p_i232250_7_, boolean p_i232250_8_, int p_i232250_9_) {
            this.buffer = p_i232250_2_;
            this.emojis = emojis;
            this.x = p_i232250_3_;
            this.y = p_i232250_4_;
            this.dropShadow = p_i232250_6_;
            this.dimFactor = p_i232250_6_ ? 0.25f : 1.0f;
            this.r = (float)(p_i232250_5_ >> 16 & 0xFF) / 255.0f * this.dimFactor;
            this.g = (float)(p_i232250_5_ >> 8 & 0xFF) / 255.0f * this.dimFactor;
            this.b = (float)(p_i232250_5_ & 0xFF) / 255.0f * this.dimFactor;
            this.a = (float)(p_i232250_5_ >> 24 & 0xFF) / 255.0f;
            this.matrix = p_i232250_7_;
            this.seeThrough = p_i232250_8_;
            this.packedLight = p_i232250_9_;
        }

        private void addEffect(class_382.class_328 p_238442_1_) {
            if (this.effects == null) {
                this.effects = Lists.newArrayList();
            }
            this.effects.add(p_238442_1_);
        }

        public boolean accept(int pos, class_2583 style, int charInt) {
            class_377 font = EmojiFontRenderer.this.method_27526(style.method_27708());
            if (Services.CONFIG.renderEmoji() && this.emojis.get(pos) != null) {
                Emoji emoji = this.emojis.get(pos);
                if (emoji != null && !this.dropShadow) {
                    EmojiUtil.renderEmoji(emoji, this.x, this.y, this.matrix, this.buffer, this.packedLight);
                    this.x += 10.0f;
                    return true;
                }
            } else {
                float f7;
                float f2;
                float f1;
                float f;
                class_379 iglyph = font.method_2011(charInt, EmojiFontRenderer.this.field_39925);
                class_382 texturedglyph = style.method_10987() && charInt != 32 ? font.method_2013(iglyph) : font.method_2014(charInt);
                boolean flag = style.method_10984();
                float f3 = this.a;
                class_5251 color = style.method_10973();
                if (color != null) {
                    int i = color.method_27716();
                    f = (float)(i >> 16 & 0xFF) / 255.0f * this.dimFactor;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.dimFactor;
                    f2 = (float)(i & 0xFF) / 255.0f * this.dimFactor;
                } else {
                    f = this.r;
                    f1 = this.g;
                    f2 = this.b;
                }
                if (!(texturedglyph instanceof class_384)) {
                    float f5 = flag ? iglyph.method_16799() : 0.0f;
                    float f4 = this.dropShadow ? iglyph.method_16800() : 0.0f;
                    class_4588 ivertexbuilder = this.buffer.getBuffer(texturedglyph.method_24045(this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993));
                    EmojiFontRenderer.this.method_1710(texturedglyph, flag, style.method_10966(), f5, this.x + f4, this.y + f4, this.matrix, ivertexbuilder, f, f1, f2, f3, this.packedLight);
                }
                float f6 = iglyph.method_16798(flag);
                float f4 = f7 = this.dropShadow ? 1.0f : 0.0f;
                if (style.method_10986()) {
                    this.addEffect(new class_382.class_328(this.x + f7 - 1.0f, this.y + f7 + 4.5f, this.x + f7 + f6, this.y + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                if (style.method_10965()) {
                    this.addEffect(new class_382.class_328(this.x + f7 - 1.0f, this.y + f7 + 9.0f, this.x + f7 + f6, this.y + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
                }
                this.x += f6;
                return true;
            }
            return false;
        }

        public float finish(int p_238441_1_, float p_238441_2_) {
            if (p_238441_1_ != 0) {
                float f = (float)(p_238441_1_ >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(p_238441_1_ >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(p_238441_1_ >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(p_238441_1_ & 0xFF) / 255.0f;
                this.addEffect(new class_382.class_328(p_238441_2_ - 1.0f, this.y + 9.0f, this.x + 1.0f, this.y - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.effects != null) {
                class_377 fontSet = EmojiFontRenderer.this.method_27526(class_2583.field_24359);
                class_382 texturedglyph = fontSet.method_22943();
                class_4588 ivertexbuilder = this.buffer.getBuffer(texturedglyph.method_24045(this.seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993));
                for (class_382.class_328 texturedglyph$effect : this.effects) {
                    texturedglyph.method_22944(texturedglyph$effect, this.matrix, ivertexbuilder, this.packedLight);
                }
            }
            return this.x;
        }
    }

    class CharacterProcessor
    implements class_5481 {
        public final int pos;
        public final class_2583 style;
        public final int character;

        CharacterProcessor(int pos, class_2583 style, int character) {
            this.pos = pos;
            this.style = style;
            this.character = character;
        }

        public boolean accept(class_5224 iCharacterConsumer) {
            return iCharacterConsumer.accept(this.pos, this.style, this.character);
        }
    }
}

